/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand;

import adql.db.DBColumn;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.IdentifierField;
import adql.query.NullADQLIterator;
import adql.query.TextPosition;
import adql.query.from.ADQLTable;
import adql.query.operand.ADQLOperand;
import adql.query.operand.UnknownType;

public class ADQLColumn
implements ADQLOperand,
UnknownType {
    private TextPosition position = null;
    private String catalog = null;
    private String schema = null;
    private String table = null;
    private String column;
    private byte caseSensitivity = 0;
    private DBColumn dbLink = null;
    private ADQLTable adqlTable = null;
    private char expectedType = (char)63;

    public ADQLColumn(String string) {
        this.setColumn(string);
    }

    public ADQLColumn(String string, String string2) {
        this.setTableName(string);
        this.setColumnName(string2);
    }

    public ADQLColumn(String string, String string2, String string3) {
        this(string2, string3);
        this.setSchemaName(string);
    }

    public ADQLColumn(String string, String string2, String string3, String string4) {
        this(string2, string3, string4);
        this.setCatalogName(string);
    }

    public ADQLColumn(ADQLColumn aDQLColumn) {
        this.column = aDQLColumn.column;
        this.table = aDQLColumn.table;
    }

    protected String normalizeName(String string, IdentifierField identifierField) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.trimToSize();
        if (stringBuffer.length() == 0) {
            return null;
        }
        if (stringBuffer.length() > 1 && stringBuffer.charAt(0) == '\"' && stringBuffer.charAt(stringBuffer.length() - 1) == '\"') {
            stringBuffer.deleteCharAt(0);
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.trimToSize();
            if (stringBuffer.length() == 0) {
                return null;
            }
            this.setCaseSensitive(identifierField, true);
        }
        return stringBuffer.toString();
    }

    public final TextPosition getPosition() {
        return this.position;
    }

    public void setPosition(TextPosition textPosition) {
        this.position = textPosition;
    }

    public final String getCatalogName() {
        return this.catalog;
    }

    public final void setCatalogName(String string) {
        String string2 = this.normalizeName(string, IdentifierField.CATALOG);
        if (this.catalog == null && string2 != null || this.catalog != null && !this.catalog.equalsIgnoreCase(string2)) {
            this.dbLink = null;
        }
        this.catalog = string2;
    }

    public final String getSchemaName() {
        return this.schema;
    }

    public final void setSchemaName(String string) {
        String string2 = this.normalizeName(string, IdentifierField.SCHEMA);
        if (this.schema == null && string2 != null || this.schema != null && !this.schema.equalsIgnoreCase(string2)) {
            this.dbLink = null;
        }
        this.schema = string2;
    }

    public final String getTableName() {
        return this.table;
    }

    public final void setTableName(String string) {
        String string2 = this.normalizeName(string, IdentifierField.TABLE);
        if (this.table == null && string2 != null || this.table != null && !this.table.equalsIgnoreCase(string2)) {
            this.dbLink = null;
        }
        this.table = string2;
    }

    public final String getColumnName() {
        return this.column;
    }

    public final String getFullColumnName() {
        if (this.column == null) {
            return "";
        }
        StringBuffer stringBuffer = this.getFullColumnPrefix();
        if (stringBuffer.length() > 0) {
            stringBuffer.append('.');
        }
        if (this.isCaseSensitive(IdentifierField.COLUMN)) {
            stringBuffer.append('\"').append(this.column).append('\"');
        } else {
            stringBuffer.append(this.column);
        }
        return stringBuffer.toString();
    }

    public final StringBuffer getFullColumnPrefix() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.catalog != null) {
            if (this.isCaseSensitive(IdentifierField.CATALOG)) {
                stringBuffer.append('\"').append(this.catalog).append("\".");
            } else {
                stringBuffer.append(this.catalog).append('.');
            }
        }
        if (this.schema != null) {
            if (this.isCaseSensitive(IdentifierField.SCHEMA)) {
                stringBuffer.append('\"').append(this.schema).append("\".");
            } else {
                stringBuffer.append(this.schema).append('.');
            }
        }
        if (this.table != null) {
            if (this.isCaseSensitive(IdentifierField.TABLE)) {
                stringBuffer.append('\"').append(this.table).append("\"");
            } else {
                stringBuffer.append(this.table);
            }
        }
        return stringBuffer;
    }

    public final void setColumnName(String string) {
        String string2 = this.normalizeName(string, IdentifierField.COLUMN);
        if (this.column == null && string2 != null || this.column != null && !this.column.equalsIgnoreCase(string2)) {
            this.dbLink = null;
        }
        this.column = string2;
    }

    public final void setColumn(String string) {
        String[] stringArray;
        String[] stringArray2 = stringArray = string == null ? null : string.split("\\.");
        if (stringArray != null && stringArray.length > 4) {
            return;
        }
        int n = stringArray == null ? -1 : stringArray.length - 1;
        this.setColumnName(n < 0 ? null : stringArray[n--]);
        this.setTableName(n < 0 ? null : stringArray[n--]);
        this.setSchemaName(n < 0 ? null : stringArray[n--]);
        this.setCatalogName(n < 0 ? null : stringArray[n]);
    }

    public final boolean isCaseSensitive(IdentifierField identifierField) {
        return identifierField.isCaseSensitive(this.caseSensitivity);
    }

    public final void setCaseSensitive(IdentifierField identifierField, boolean bl) {
        this.caseSensitivity = identifierField.setCaseSensitive(this.caseSensitivity, bl);
    }

    public final boolean isCaseSensitive() {
        return IdentifierField.isFullCaseSensitive(this.caseSensitivity);
    }

    public final void setCaseSensitive(boolean bl) {
        this.caseSensitivity = IdentifierField.getFullCaseSensitive(bl);
    }

    public final byte getCaseSensitive() {
        return this.caseSensitivity;
    }

    public final void setCaseSensitive(byte by) {
        this.caseSensitivity = by;
    }

    public final DBColumn getDBLink() {
        return this.dbLink;
    }

    public final void setDBLink(DBColumn dBColumn) {
        this.dbLink = dBColumn;
    }

    public final ADQLTable getAdqlTable() {
        return this.adqlTable;
    }

    public final void setAdqlTable(ADQLTable aDQLTable) {
        this.adqlTable = aDQLTable;
    }

    @Override
    public char getExpectedType() {
        return this.expectedType;
    }

    @Override
    public void setExpectedType(char c) {
        this.expectedType = c;
    }

    @Override
    public boolean isNumeric() {
        return this.dbLink == null || this.dbLink.getDatatype() == null || this.dbLink.getDatatype().isNumeric();
    }

    @Override
    public boolean isString() {
        return this.dbLink == null || this.dbLink.getDatatype() == null || this.dbLink.getDatatype().isString();
    }

    @Override
    public boolean isGeometry() {
        return this.dbLink == null || this.dbLink.getDatatype() == null || this.dbLink.getDatatype().isGeometry();
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new ADQLColumn(this);
    }

    @Override
    public String getName() {
        return this.getColumnName();
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new NullADQLIterator();
    }

    @Override
    public String toADQL() {
        return this.getFullColumnName();
    }

    public String toString() {
        return this.toADQL();
    }
}

